/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.File;
import java.util.logging.Level;
import org.autoplot.ScriptContext;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.dom.Application;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.LoggerManager;

public class Test034 {
    private static final String tsbURI = "http://cdaweb.gsfc.nasa.gov/istp_public/data/polar/hydra/hyd_h0/$Y/po_h0_hyd_$Y$m$d_v01.cdf?ELECTRON_DIFFERENTIAL_ENERGY_FLUX&timerange=20000109";
    private static final String noTsbURI = "http://cdaweb.gsfc.nasa.gov/istp_public/data/polar/hydra/hyd_h0/2000/po_h0_hyd_20000109_v01.cdf?ELECTRON_DIFFERENTIAL_ENERGY_FLUX";

    private static void test001() throws Exception {
        ScriptContext.reset();
        Application dom = ScriptContext.getDocumentModel();
        ScriptContext.plot(tsbURI);
        dom.getPlots(0).getController().contextOverview();
        DatumRange z = dom.getPlots(1).getXaxis().getRange();
        z = DatumRangeUtil.rescale((DatumRange)z, (double)-0.3, (double)1.3);
        dom.getPlots(1).getXaxis().setRange(z);
        ScriptContext.writeToPng("test034_001.png");
    }

    private static void test002() throws Exception {
        ScriptContext.reset();
        Application dom = ScriptContext.getDocumentModel();
        ScriptContext.plot(tsbURI);
        dom.getPlots(0).getController().contextOverview();
        dom.getPlotElements(1).setComponent("|slice0(100)");
        ScriptContext.writeToPng("test034_002.png");
    }

    private static void test003() throws Exception {
        ScriptContext.reset();
        LoggerManager.getLogger((String)"autoplot.dom").setLevel(Level.ALL);
        Application dom = ScriptContext.getDocumentModel();
        ScriptContext.plot(noTsbURI);
        dom.getPlots(0).getController().contextOverview();
        dom.getPlotElements(1).setComponent("|slice0(100)");
        ScriptContext.writeToPng("test034_003.png");
    }

    private static void test004() throws Exception {
        ScriptContext.reset();
        Application dom = ScriptContext.getDocumentModel();
        ScriptContext.plot("file:/home/jbf/ct/hudson/vap/lanl/lanlGeoEpDemo4.vap");
        ScriptContext.writeToPng("test034_004a.png");
        DatumRange tr = dom.getTimeRange();
        tr = DatumRangeUtil.rescale((DatumRange)tr, (double)-0.7, (double)0.3);
        dom.setTimeRange(tr);
        ScriptContext.writeToPng("test034_004b.png");
    }

    public static void main(String[] args) throws Exception {
        ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
        System.err.println("pwd: " + new File(".").getCanonicalPath());
        System.err.println("autoplot_data: " + AutoplotSettings.settings().resolveProperty("autoplotData"));
        System.err.println("fscache: " + AutoplotSettings.settings().resolveProperty("fscache"));
        long t0 = System.currentTimeMillis();
        Test034.test003();
        System.err.printf("test 003a: done in %9.2f sec\n", (double)(System.currentTimeMillis() - t0) / 1000.0);
        System.err.println("==========================");
        t0 = System.currentTimeMillis();
        Test034.test001();
        System.err.printf("test 001: done in %9.2f sec\n", (double)(System.currentTimeMillis() - t0) / 1000.0);
        System.err.println("==========================");
        t0 = System.currentTimeMillis();
        Test034.test002();
        System.err.printf("test 002: done in %9.2f sec\n", (double)(System.currentTimeMillis() - t0) / 1000.0);
        System.err.println("==========================");
        t0 = System.currentTimeMillis();
        Test034.test003();
        System.err.printf("test 003: done in %9.2f sec\n", (double)(System.currentTimeMillis() - t0) / 1000.0);
        System.err.println("==========================");
        t0 = System.currentTimeMillis();
        Test034.test004();
        System.err.printf("test 004: done in %9.2f sec\n", (double)(System.currentTimeMillis() - t0) / 1000.0);
        System.exit(0);
    }
}

